/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: sharedmem.h,v 1.3 1999/03/10 03:03:20 heller Exp $
____________________________________________________________________________*/

#pragma once 

#ifdef __cplusplus
extern "C" {
#endif

#if PRAGMA_ALIGN_SUPPORTED
#pragma options align=mac68k
#endif



// Gestalt selector
enum {
	kSharedMemSelector	=	'PVTL'
};

// Possible errors
enum {
	err_Unknown			=	'Uknw',
	err_AllocationError	=	'Aloc',
	err_BlockNotFound	=	'BkNF',
	err_DuplicateName	=	'DpNm'
};

// Memory block structure
typedef struct NamedBlock{
	Str31				name;
	struct NamedBlock *	link;
	Byte				data[1];
} NamedBlockS, *NamedBlockP;


// Function declarations
SInt32 NewNamedBlock(const Str31 inName, const UInt32 inSize,
Ptr * outAddress);
SInt32 GetNamedBlock(const Str31 inName, Ptr * outAddress);
SInt32 ReleaseNamedBlock(const Str31 inName);




#if PRAGMA_ALIGN_SUPPORTED
#pragma options align=reset
#endif

#ifdef __cplusplus
}
#endif
